#include <bits/stdc++.h>
using namespace std;

struct Teme {
    long long x, y;
};

long long vektorskiProizvod(const Teme& O, const Teme& A, const Teme& B) {
    return (A.x - O.x) * (B.y - O.y) - (A.y - O.y) * (B.x - O.x);
}

vector<Teme> konveksniOmotac(vector<Teme>& tacke) {
    int n = tacke.size(), k = 0;
    if (n == 1) return tacke;
    vector<Teme> omotac(2 * n);


    sort(tacke.begin(), tacke.end(), [](Teme a, Teme b) {
        return a.x < b.x || (a.x == b.x && a.y < b.y);
    });


    for (int i = 0; i < n; ++i) {
        long long tmp=vektorskiProizvod(omotac[k - 2], omotac[k - 1], tacke[i]);
        while (k >= 2 && tmp <= 0) k--;
        omotac[k++] = tacke[i];
    }



    for (int i = n - 2, t = k + 1; i >= 0; --i) {
        long long tmp=vektorskiProizvod(omotac[k - 2], omotac[k - 1], tacke[i]);
        while (k >= t && tmp <= 0) k--;
        omotac[k++] = tacke[i];
    }
    omotac.resize(k - 1);
    return omotac;
}

long long povrsina(const vector<Teme>& omotac) {
    long long P = 0;
    int n = omotac.size();
    for (int i = 0; i < n; ++i) {
        P = P+ omotac[i].x * omotac[(i + 1) % n].y - omotac[i].y * omotac[(i + 1) % n].x;
    }
    return abs(P) / 2;
}

int main() {
    int brojTacaka;
    cin >> brojTacaka;
    vector<Teme> tacke(brojTacaka);
    
    for (int i = 0; i < brojTacaka; i++) {
        cin >> tacke[i].x >> tacke[i].y;
    }

    if (brojTacaka == 4) {
        long long minimalnaPovrsina = LLONG_MAX;
        for (int i = 0; i < brojTacaka; i++) {
            vector<Teme> podskup;
            for (int j = 0; j < brojTacaka; j++) {
                if (i != j) podskup.push_back(tacke[j]);
            }
            vector<Teme> omotac = konveksniOmotac(podskup);
            minimalnaPovrsina = min(minimalnaPovrsina, povrsina(omotac));
        }
        cout << minimalnaPovrsina << endl;
    } else {
        vector<Teme> omotac = konveksniOmotac(tacke);
        cout << povrsina(omotac) << endl;
    }

    return 0;
}